<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Console;
ini_set("max_execution_time",0);
ini_set('memory_limit', '3096M');
ini_set('display_errors', false);
error_reporting(E_ERROR | E_PARSE );




use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Filesystem\Exception\FileNotFoundException; 



/**
 * Command for executing cron jobs
 */

class ProductexportCommand extends command
{
    const NOTI_RECIPIENTS = array(); // array('C.Hussmann@xtwostore.com', 'J.Rascher@xtwostore.com', 'S.Geissler@xtwostore.com');
    const NOTI_RECIPIENTS_ERROR = array('bodo@justselling.de', 'C.Hussmann@xtwostore.com');

    /** @var Xtento_ProductExport_Model_Profile $currentProfile */
    protected $currentProfile = null;

    protected $isSuccess = false;

    /**
     * @var 
     */
   

  
    /**
     * Run script
     *
     */
    protected function execute(InputInterface $input, OutputInterface $output)    
    {
        try {
            if ($profileId = $this->getProfileID()) {
                $profile = Mage::getModel('xtento_productexport/profile')->load($profileId);
                $this->currentProfile = $profile;
                $exportModel = Mage::getModel('xtento_productexport/export', array('profile' => $profile));
                $filters = Mage::getModel('xtento_productexport/observer_cronjob')->addProfileFilters($profile);
                echo sprintf('Start profile export "%s"...', $profile->getName());
                $exportModel->cronExport($filters);
                echo sprintf('Finished!');

                $this->isSuccess = true;

                $this->mail(self::NOTI_RECIPIENTS,
                    sprintf('Export Profile %s/%s finished', $profile->getId(), $profile->getName()));

            } else {
                echo $this->usageHelp();
            }

        } catch (Exception $e) {

            $this->mail(self::NOTI_RECIPIENTS_ERROR,
                sprintf('Profile-Export %s/%s with Exception!', $this->currentProfile ? $this->currentProfile->getId() : '-',
                    $this->currentProfile ? $this->currentProfile->getName() : ''),
                sprintf("Problem:\n\ncode=%s\nmessage=%s\n\n\ntrace=%s", $e->getCode(), $e->getMessage(), $e->getTraceAsString()));
        }
    }

    public function onShutdown() {
        $error = error_get_last();
        if (!empty($error) && !$this->isSuccess) {
            $this->mail(self::NOTI_RECIPIENTS_ERROR,
                sprintf('Profile-Export %s/%s with Error!', $this->currentProfile ? $this->currentProfile->getId() : '-',
                    $this->currentProfile ? $this->currentProfile->getName() : ''),
                sprintf("Problem:\n type=%s\nmessage=%s\nline=%s", $error['type'], $error['message'], $error['line']));
        }
    }

    /**
     * @param $recipients
     * @param $subject
     * @param string $body
     */
    protected function mail($recipients, $subject, $body='') {
        $rec = implode(', ', $recipients);
        $header = 'From: export@xtwostore.de'. "\r\n" .
            'Reply-To: noreply@xtwostore.de'."\r\n" .
            'X-Mailer: PHP/' . phpversion().'/justSelling-Power';
        mail($rec, $subject, $body, $header);
    }

    /**
     * Retrieve Usage Help Message
     *
     */
    public function usageHelp()
    {
        return <<<USAGE
Usage:  php productexport.php --profile <ID>

  ID                The ID of the profile to export
  help              This help


USAGE;
    }


    /**
     * Retrieve argument value by name or false
     *
     * @return mixed
     */
    public function getProfileID()
    {
        $id = $this->getArg('profile');
        return $id ? $id : false;
    }
}


