<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */


namespace Xtwo\Automationshell\Console;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Filesystem\Exception\FileNotFoundException;

/**
 * Command for executing cron jobs
 */

class AttributeOptionCopyCommand extends Command
{

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var 
     */
    

    public function __construct(
        \Magento\Eav\Api\AttributeRepositoryInterface $eavAttributeRepositoryInterface,
      
        \Magento\Framework\App\ResourceConnection $resource,
        \Magento\Eav\Model\Config $eavConfig,
        
        \Magento\Catalog\Model\Product $productsingleton,     
        \Psr\Log\LoggerInterface $logger,
        \Magento\Eav\Model\Attribute $eavAttribute,
        \Magento\Eav\Model\Entity $entity,
        
        \Magento\Framework\App\State $state,
       
        \Magento\Store\Model\Store $store,
        \Magento\Store\Api\StoreRepositoryInterface $storeRepository,
       
        \Magento\Catalog\Model\ProductFactory $product,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \Magento\Catalog\Model\ResourceModel\Product\Action $productAction,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        
        \Magento\Framework\TranslateInterface $translator,
        
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Group\CollectionFactory $attributeGroupCollection,
        \Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory $productAttributeCollection
    ) {
      
        $this->storeRepository= $storeRepository;
        $this->eavAttributeRepository = $eavAttributeRepositoryInterface;
        $this->logger = $logger; 
        $this->state = $state;
        $this->store = $store;
        $this->product = $product;
        $this->resourceConnection = $resourceConnection;
        $this->connection = $this->resourceConnection->getConnection();        
        $this->eavAttribute = $eavAttribute;
        $this->storeManager = $storeManager;
        $this->attributeGroupCollection = $attributeGroupCollection;
        $this->resource = $resource;
        $this->eavConfig = $eavConfig;        
        parent::__construct();
    }


    protected function configure()
    {
                
        $this->setName('Xtwo:AttributesOptionCopy')
            ->setDescription('Attributes Option Copy')         
            ->addOption('src', "s", InputOption::VALUE_OPTIONAL, "--src xtwostore_de")
            ->addOption('target', "t", InputOption::VALUE_OPTIONAL, "--target xtwostore_at")
            ->addOption('attribute', "a", InputOption::VALUE_OPTIONAL, "--attribute color")
            ->addOption('no-override', "ov", InputOption::VALUE_OPTIONAL, "--no-override 0");
          
            parent::configure();
    }

    /**
     * @param string $msg
     * @return Mage_Log_Model_Log
     */
    protected function log($msg)
    {
        $this->logger->log("error",$msg);
    }

    /** @param $msg */
    protected function echoAndLog($msg, $isIntro = false, $skipLineBreak = false)
    {
        $echo = ($isIntro) ? $msg : '   ' . $msg;
        $lb = $skipLineBreak ? '' : "\n";
        echo $echo . $lb;
        $this->log($echo);
    }

    /**
     * Run script
     * @param InputInterface $input, OutputInterface $output
     * @return string
     */

    protected function execute(InputInterface $input, OutputInterface $output)  
    {
        $this->input = $input;
        if(!$this->input->getOption('attribute')){
            $this->echoAndLog('no attribute');

        }

        $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND); 
        $this->input = $input;

        $targetStores = $this->input->getOption('target');
       

        if ($this->input->getOption('src') && $this->input->getOption('target')) {

            $storeCodeSrc = $this->input->getOption('src');
            $storeCodeTarget = $this->input->getOption('target');
          
            if (!$storeCodeSrc || !$storeCodeTarget) {
                $this->echoAndLog('One of options missing: src or target');

            } 
            
            if (($val = $this->validate()) !== true) {
               $this->echoAndLog('Invalid parameters: ' . $val);
            } 
            else {
                $this->process();
            }
        } else {
           //  echo $this->usageHelp();
        }
    }

    protected function process() {
      
        // $coreResource = Mage::getSingleton('core/resource');
        $coreResource = $this->resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
        $tblGalVal = $coreResource->getTableName('eav_attribute_option_value');

        $srcStore = $this->input->getOption('src');
        $targetStores = $this->input->getOption('target');
     
        $targetStore_ar = explode(",",$targetStores);
        
        foreach($targetStore_ar as $targetStore) {
            $store0 = $this->storeRepository->get($srcStore);
            $srcStoreId = $store0->getId(); // this is the store ID
            $store1 = $this->storeRepository->get($targetStore);
            $targetStoreId = $store1->getId(); // this is the store ID
            $attributes = $this->getAttributes();
            
            if (!empty($attributes)) {
                $this->echoAndLog(sprintf('%s attribute candidates for processing. Start im 5 sec...', count($attributes)));
                sleep(5);
            } else {
                $this->echoAndLog('No attributes to process or invalid attribute code!');
                return;
        }
        

        /** @var $attribute Mage_Eav_Model_Entity_Attribute */
        foreach ($attributes as $attribute) {
           
           // print $attribute->getName(); 
           // die();
          //  $attribute = $this->eavConfig->getAttribute('catalog_product', $attribute->getCode());
          //  $valuesSrc = $attribute->getSource()->setAttributeFilter($attribute->getId())->setStoreFilter($srcStore->getId(), false);
            //   ->setStoreFilter($srcStore->getId(), false);->getAllOptions();
           // $valuesSrc = Mage::getResourceModel('eav/entity_attribute_option_collection')
              //  ->setAttributeFilter($attribute->getId())
             //   ->setStoreFilter($srcStore->getId(), false);

             
             $attribute = $this->eavAttributeRepository->get('catalog_product', $attribute->getName()); 
            // $attribute = $this->eavAttributeRepository->get('catalog_product', $attribute->getCode()); 
            // $valuesSrc = $attribute->getSource()->setAttributeFilter($attribute->getId())->setStoreFilter($srcStore->getId(), false);
            
          //  echo $attribute->getId();
           // echo $srcStore->getId();
           // die();
            
            $valuesSrc = $attribute->setAttributeFilter($attribute->getId())->setStoreFilter($srcStoreId, false);
           
            $items = $valuesSrc->getSource()->getAllOptions();
          // echo $items->getOptionId();
         //print_r($items);
           // die();
            /// $items = $valuesSrc->getItems();
          
            $total = count((array)$items);
            $overridden = 0; $set = 0; $skipped = 0;
            foreach ($items as $item) {
                // print_r($item);
                // $optionId = $item->getOptionId();
                $optionId = $item['value'];
                $v = $this->connection->fetchOne("SELECT value_id FROM $tblGalVal WHERE option_id=:optionId AND store_id=:storeId",
                    array('optionId' => $optionId, 'storeId' => $targetStoreId));

                $valueDefault = $this->connection->fetchOne("SELECT value FROM $tblGalVal WHERE option_id=:optionId AND store_id=:storeId",
                    array('optionId' => $optionId, 'storeId' => 0));
               // echo $valueDefault." == ".$item['value']."\r\n";    
                if ($valueDefault == $item['value']) {
                    // skip
                    $skipped++;

                } elseif ($v) {
                   
                    if ($this->isOverrideDeactivated()) {
                        continue;
                    }
                  
                   $sql = "UPDATE $tblGalVal SET value=:label WHERE value_id=:valueId AND store_id=:storeId";
                    $this->connection->query($sql, array('valueId'=>$v, 'storeId'=>$targetStoreId,'label'=>$item['label']));
                   // echo "";
                 //  echo "UPDATE $tblGalVal SET value='".$item['label']."' WHERE value_id='$v' AND store_id='$targetStoreId'";               
                    $overridden++;
                } else {
                    $sql = "INSERT IGNORE INTO $tblGalVal (option_id, store_id, value) VALUES " .
                        '(:optionId, :storeId, :label)';
                        $this->connection
                        ->query($sql, array('optionId' => $optionId, 'storeId' => $targetStoreId,
                                            'label'    => $item['label']));
                    $set++;
                }
            }
            $this->echoAndLog(sprintf('%s: total processed: %s, overridden: %s, set: %s, skipped: %s',
                $attribute->getAttributeCode(), $total, $overridden, $set, $skipped));

        }
    }

    }

    /**
     * @return \Magento\Eav\Model\Entity\Attribute\AbstractAttribute[]
     */
    protected function getAttributes() {
        /** @var \Magento\Eav\Model\Config $eavConfig */
      //  $eavConfig = Mage::getSingleton('eav/config');
        $eavConfig  = $this->eavConfig; 
        $attr = $this->input->getOption('attribute');
        $attributeCodes = !empty($attr) ? explode(',', $attr) :
        $eavConfig->getEntityAttributeCodes(\Magento\Catalog\Model\Product::ENTITY);
   
        $attributes = [];
        foreach ($attributeCodes as $attributeCode) {
           // echo $attributeCode;
            $attribute = $eavConfig->getAttribute(\Magento\Catalog\Model\Product::ENTITY, $attributeCode);
           
            if ($attribute && $attribute->getId() && $attribute->usesSource()) {
                $attributes[] = $attribute;
            }
        }
        return $attributes;
    }

    protected function getStore($type='src') {
        if($type == 'target'){
            $storeCodeSrc = $this->input->getOption($type);
            $storeCodeSrc_ar =  explode(',',$storeCodeSrc);
            try {
                foreach($storeCodeSrc_ar as $dstore) {
                  $store = $this->storeManager->getStore($dstore);
                  return $store;
                }
            } catch (Exception $e) {
                return false;
            }
       } else {
            try {
                $storeCodeSrc = $this->input->getOption($type);
                $store = $this->storeManager->getStore($storeCodeSrc);
                return $store;
                
            } catch (Exception $e) {
                return false;
            }
       }
    }

    protected function isOverrideDeactivated() {
        $arg = $this->input->getOption('no-override');
        return !empty($arg);
    }

    protected function validate() {
        $failures = array();
        if (!$this->getStore('src')) {
         $failures['Invalid src store code'] = 1;
        }
        if (!$this->getStore('target')){ 
         $failures['Invalid target store code'] = 2;
        }
        if (count($failures)) {
            return implode(',', $failures);
        }
        return true;
    }

    /**
     * Retrieve Usage Help Message
     *
     */
    public function usageHelp()
    {
        return <<<USAGE
Usage:  sudo php bin/magento Xtwo:AttributesOptionCopy [--attribute] --src --target

  --attribute <attribute_code>  List of attribute codes, separated by comma. If not given, all option-attributes are copied.
  --src <store_code>
  --target <store_code>

            Example:
            sudo php bin/magento Commands:AttributesOptionCopy --attribute color --src xtwostore_de --target xtwostore_ch

  --no-override         If given, an already existing value in target store will not be overriden.

  help                  This help

USAGE;
    }
}