<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\Automationshell\Console;


ini_set("max_execution_time", 0);

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Filesystem\Exception\FileNotFoundException;

/**
 * Command for executing cron jobs
 */

class AddAttributeCommand extends Command
{
    /**
     * @var \Magento\Eav\Model\Entity\TypeFactory
     */
    protected $eavEntityTypeFactory;

    /**
     * @var \Magento\Eav\Model\Entity\Attribute\SetFactory
     */
    protected $eavEntityAttributeSetFactory;

    /**
     * @var \Magento\Eav\Model\Entity\AttributeFactory
     */
    protected $eavEntityAttributeFactory;


    public function __construct(
        \Magento\Eav\Model\Config $eavConfig,
        \Magento\Eav\Api\AttributeRepositoryInterface $eavAttributeRepositoryInterface,
        \Magento\Eav\Model\Entity\TypeFactory $eavEntityTypeFactory,
        \Magento\Eav\Model\Entity\Attribute\SetFactory $eavEntityAttributeSetFactory,
        \Magento\Eav\Model\Entity\AttributeFactory $eavEntityAttributeFactory,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Eav\Model\Attribute $eavAttribute,
        \Magento\Eav\Model\Entity $entity,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory $attributesetCollection,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Group\CollectionFactory $attributeGroupCollection

    )
    {

        $this->eavEntityTypeFactory = $eavEntityTypeFactory;
        $this->eavEntityAttributeSetFactory = $eavEntityAttributeSetFactory;
        $this->eavEntityAttributeFactory = $eavEntityAttributeFactory;
        $this->logger = $logger;
        $this->attributeGroupCollection = $attributeGroupCollection;
        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */

    protected function configure()
    {

        $this->setName('Xtwo:AddAttributeCommand')
            ->setDescription('Adds the given attribute to ALL attribute sets!')
            ->addOption('attribute', "attr", InputOption::VALUE_OPTIONAL, "--attribute attribute codes");
        parent::configure();
    }

    /**
     * Run script
     * @param InputInterface $input, OutputInterface $output
     * @return string
     */

    protected function execute(InputInterface $input, OutputInterface $output)
    {

        $this->input = $input;

        $attributeCode = (string) $this->input->getOption('attribute');
        if (!$attributeCode) {
            die("\r\nCan't read attribute.\r\n");
        }


        $attSet = $this->eavEntityTypeFactory->create()->getCollection()->addFieldToFilter('entity_type_code', 'catalog_product')->getFirstItem();
        $attSetCollection = $this->eavEntityTypeFactory->create()->load($attSet->getId())->getAttributeSetCollection(); // this is the attribute sets associated with this entity
        $attributeInfo = $this->eavEntityAttributeFactory->create()->getCollection()->setCodeFilter($attributeCode)->getFirstItem();



        if (!$attributeInfo) {
            die("\r\nCan't find attribute.\r\n");
        }
        // echo $attributeCode;
        $attCode = $attributeInfo->getAttributeCode();

        $attId = $attributeInfo->getId();
        foreach ($attSetCollection as $a) {
            $set = $this->eavEntityAttributeSetFactory->create()->load($a->getId());
            $setId = $set->getId();


            $group = $this->attributeGroupCollection->create()->addFieldToFilter('attribute_set_id', $setId)->setOrder('attribute_group_id', 'ASC')->getFirstItem();

            $groupId = $group->getId();
            $newItem = $this->eavEntityAttributeFactory->create();
            $newItem->setEntityTypeId($attSet->getId())
                ->setAttributeSetId($setId)
                ->setAttributeGroupId($groupId)
                ->setAttributeId($attId)
                ->setSortOrder(10)
                ->setfrontendLabel($attCode)
                ->save();
            echo "Attribute " . $attCode . " added to attribute set: " . $group->getAttributeGroupName() . " / " . $set->getAttributeSetName() . "\r\n";
        }
        echo "--> done\r\n";
    }

    /**
     * Retrieve Usage Help Message
     *
     */
    public function usageHelp()
    {
        return <<<USAGE

Adds the given attribute to ALL attribute sets!

Usage:  php -f Xtwo:AddAttributeCommand -- [options]
 
  --attribute      Attribute code
  help             This help

USAGE;
    }
}