<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Block\Adminhtml\Shelljob\Edit;

use Exception;

/**
 * Class Tabs
 * @package Xtwo\Automationshell\Block\Adminhtml\Shelljob\Edit
 */
class Tabs extends \Magento\Backend\Block\Widget\Tabs
{
    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        parent::_construct();

        $this->setId('job_tabs');
        $this->setDestElementId('edit_form');
        $this->setTitle(__('Shell command details'));
    }

    /**
     * @inheritdoc
     * @throws Exception
     */
    protected function _beforeToHtml()
    {
        $this->addTab('main', [
            'label'   => __('General'),
            'title'   => __('General'),
            'content' => $this->getChildHtml('main'),
            'active'  => true
        ]);

        return parent::_beforeToHtml();
    }
}
