<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Block\Adminhtml\Shelljob\Edit;


use Xtwo\Automationshell\Model\Config\Source\ShellCommandList;
use Magento\Store\Model\System\Store;
class Form extends \Magento\Backend\Block\Widget\Form\Generic{

    protected $_job;
    /**
     * @var
     */
    protected $_systemStore;
    
    protected $_approved;


    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig,
        \Xtwo\Automationshell\Model\Source\Approved $approved,
        \Xtwo\Automationshell\Model\Source\Status $status,
        ShellCommandList $shellCommandList,
        Store $systemStore,
        array $data = []
    )
    {
        $this->shellCommandList = $shellCommandList;
        $this->_wysiwygConfig = $wysiwygConfig;
        $this->_approved = $approved;
        $this->_status = $status;
        $this->systemStore = $systemStore;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * @return Form
     * @throws \Magento\Framework\Exception\LocalizedException
     */

    protected function _prepareForm(){
        $model = $this->_coreRegistry->registry('row_data');

        $form = $this->_formFactory->create([
            'data' => [
                'id' => 'edit_form', 
                'enctype' => 'multipart/form-data', 
                'action' => $this->getData('action'), 
                'method' => 'post'
            ]
        ]);
        // $form->setHtmlIdPrefix('md_cr_');
        if ($model) {
            $fieldset = $form->addFieldset('base_fieldset', [
                'legend' => __('Shell command Details'), 
                'class' => 'fieldset-wide']
            );
            $fieldset->addField('command_id', 'hidden', [
                'name' => 'command_id',
                "value" => 1]);
        } else {
            $fieldset = $form->addFieldset('base_fieldset', [
                'legend' => __('Shell command Details'), 
                'class' => 'fieldset-wide']);
        }

       /* $fieldset->addField('code', 'text', [
            'name'     => 'code',
            'label'    => __('Shell Command Code'),
            'title'    => __('Shell Command Code'),
            'class'    => 'validate-code',
            'value'    => '',
            'required' => true
        ]);*/

        $fieldset->addField('command_name', 'text', [
            'name'     => 'command_name',
            'label'    => __('Command Name'),
            'title'    => __('Command Name'),
          //  'class'    => 'validate-code',
            'value'    => '',
            'required' => true
        ]);
        /*
        $fieldset->addField('command_identifier', 'text', [
            'name'     => 'command_identifier',
            'label'    => __('Command identifier'),
            'title'    => __('Command identifier'),
           // 'class'    => 'validate-code',
            'value'    => '',
            'required' => true
        ]);
        */

        $parentField =  $fieldset->addField('shell_command', 'select', [
            'name'   => 'shell_command',
            'label'  => __('Select Shell Command'),
            'title'  => __('Select Shell Command'),
            'required' => true,
            'values' => $this->shellCommandList->toOptionArray()
        ]);
        

        /*$childField_source_store =  $fieldset->addField('source_stores', 'text', [
            'name'   => 'source_stores',
            'label'  => __('Source store'),
            'title'  => __('Source store'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple source store code.')
        ]);*/
        $childField_source_store = $fieldset->addField('source_stores','multiselect',[
                'label' => __('Source store'),
                'title' => __('Source store'),
                'name' => 'source_stores',
                'value' => '',
                'values' => $this->systemStore->getStoreValuesForForm(false, true)
            ]
        );

        
        $childField_target_store = $fieldset->addField('target_stores', 'text', [
            'name'   => 'target_stores',
            'label'  => __('Target store'),
            'title'  => __('Target store'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple target store code.')
        ]);

       $childField_skus =   $fieldset->addField('skus', 'text', [
            'name'   => 'skus',
            'label'  => __('SKUs'),
            'title'  => __('SKUs'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple sku.')
        ]);

        $childField_update_price_sku =   $fieldset->addField('update_price_sku', 'text', [
            'name'   => 'update_price_sku',
            'label'  => __('SKUs'),
            'title'  => __('SKUs'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple sku.')
        ]);

        $childField_autofill_skus =   $fieldset->addField('autofill_skus', 'text', [
            'name'   => 'autofill_skus',
            'label'  => __('SKUs'),
            'title'  => __('SKUs'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple sku.')
        ]);


        $childField_reset_skus =   $fieldset->addField('reset_skus', 'text', [
            'name'   => 'reset_skus',
            'label'  => __('SKUs'),
            'title'  => __('SKUs'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple sku.')
        ]);

     
       $childField_attributeimagedefault_skus =   $fieldset->addField('skus_default_image', 'text', [
            'name'   => 'skus_default_image',
            'label'  => __('Skus'),
            'title'  => __('Skus'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple sku.')
        ]);

        $childField_attributeimagedefault_optional =   $fieldset->addField('optional_default_image', 'text', [
            'name'   => 'optional_default_image',
            'label'  => __('Optional Parameter'),
            'title'  => __('Skus'),
            //'required' => true,
            'values' =>'',
            'note'     => __(' --all(To ensure that a reset to default is really desired for ALL stores)  --sort-order-only(If specified, it only adjusts the sort order of the existing store-releated images)')
        ]);

        $childField_skus_value_copy =   $fieldset->addField('skus_value_copy', 'text', [
            'name'   => 'skus_value_copy',
            'label'  => __('Skus'),
            'title'  => __('Skus'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple sku.')
        ]);


       $childField_attribute_lists_option_copy =  $fieldset->addField('attribute_lists_option_copy', 'text', [
            'name'   => 'attribute_lists_option_copy',
            'label'  => __('Attribute lists'),
            'title'  => __('Attribute lists'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple attribute.')
        ]);

        $childField_attribute_reset_lists =  $fieldset->addField('reset_attribute_lists', 'text', [
            'name'   => 'reset_attribute_lists',
            'label'  => __('Attribute code lists'),
            'title'  => __('Attribute code lists'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple attribute.')
        ]);

        $childField_attribute_lists_add_attr =  $fieldset->addField('add_attribute_lists', 'text', [
            'name'   => 'add_attribute_lists',
            'label'  => __('Attribute code lists'),
            'title'  => __('Attribute code lists'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter attribute code.')
        ]);


        $childField_autofill_attributesets = $fieldset->addField('autofill_attributesets', 'text', [
            'name'   => 'autofill_attributesets',
            'label'  => __('Attribute sets'),
            'title'  => __('Attribute sets'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter attributeset ex: Ablaufgarnituren')
        ]);


        $childField_surcharge = $fieldset->addField('surcharge', 'text', [
            'name'   => 'surcharge',
            'label'  => __('Surcharge'),
            'title'  => __('Surcharge'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter surcharge value Ex: 9.90')
        ]);

        $childField_links = $fieldset->addField('links', 'text', [
            'name'   => 'links',
            'label'  => __('Links'),
            'title'  => __('Links'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated skus values if you have values ex: 01800180, 27296001, 5614R0R1')
        ]);

       
       $childField_type = $fieldset->addField('type', 'text', [
            'name'   => 'type',
            'label'  => __('Type'),
            'title'  => __('Type'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter type from list only ex: relation|upsell|cross_sell|series_sell|alternative_sell|spare_sell|sample_sell')
        ]);


        $childField_add_delete_info = $fieldset->addField('add_delete_info', 'text', [
            'name'   => 'add_delete_info',
            'label'  => __('Add/Delete/Info'),
            'title'  => __('Add/Delete/Info'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter type action from list add|delete')
        ]);
       

        $childField_store = $fieldset->addField('store', 'text', [
            'name'   => 'store',
            'label'  => __('Source Store'),
            'title'  => __('Source Store'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter store code.')
        ]);
        


        $childField_reset_store = $fieldset->addField('reset_store', 'text', [
            'name'   => 'reset_store',
            'label'  => __('Store(Attribute Reset)'),
            'title'  => __('Store'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple source store code.')
        ]);

        $childField_store_value_copy_target = $fieldset->addField('store_value_copy_target', 'text', [
            'name'   => 'store_value_copy_target',
            'label'  => __('Target Store'),
            'title'  => __('Target Store'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple target store code.')
        ]);

        $childField_store_value_copy_source = $fieldset->addField('store_value_copy_source', 'text', [
            'name'   => 'store_value_copy_source',
            'label'  => __('Source Store'),
            'title'  => __('Source Store'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple source store code.')
        ]);


        $childField_update_prices_store = $fieldset->addField('update_prices_store', 'text', [
            'name'   => 'update_prices_store',
            'label'  => __('Store'),
            'title'  => __('Store'),
            //'required' => true,
            'values' =>'',
            'note'     => __(' Please enter comma(,) seperated values if you have multiple store code.')
        ]);
      
        $childField_attributeimagedefault_store = $fieldset->addField('store_default_image', 'text', [
            'name'   => 'store_default_image',
            'label'  => __('Store'),
            'title'  => __('Store'),
            //'required' => true,
            'values' =>'',
            'note'     => __('Please enter comma(,) seperated values if you have multiple store code.')
        ]);
 

        $childField_nooverride = $fieldset->addField('nooverride', 'text', [
            'name'   => 'nooverride',
            'label'  => __('No Override'),
            'title'  => __('No Override'),
            //'required' => true,
            'values' =>'',
            'note'     => __('--no-override 0|--no-override 1')
        ]);


        $childField_ignoredefaults_value_copy  = $fieldset->addField('ignoredefaults_value_copy', 'text', [
            'name'   => 'ignoredefaults_value_copy',
            'label'  => __('ignoredefaults'),
            'title'  => __('ignoredefaults'),
            //'required' => true,
            'values' =>'',
            'note'     => __('--ignoredefaults 1')
        ]);

        $childField_removeallfor  = $fieldset->addField('remove_all_for', 'text', [
            'name'   => 'remove_all_for',
            'label'  => __('Remove all for'),
            'title'  => __('Remove all for'),
            //'required' => true,
            'values' =>'',
            'note'     => __('--removeallfor 1728904')
        ]);

        $childField_folderlimit  = $fieldset->addField('folderlimit', 'text', [
            'name'   => 'folderlimit',
            'label'  => __('Folderlimit'),
            'title'  => __('Folder limit'),
            //'required' => true,
            'values' =>'',
            'note'     => __('--folderlimit 4')
        ]);

        $childField_prod_image_optional  = $fieldset->addField('prod_optional', 'text', [
            'name'   => 'prod_optional',
            'label'  => __('Product Image Optional Param'),
            'title'  => __('Product Image Optional Param'),
            //'required' => true,
            'values' =>'',
            'note'     => __('--cleanup 1 --real 1 --reset 1')
        ]);


        $this->setChild(
            'form_after',
            $this->getLayout()->createBlock(
                'Xtwo\Automationshell\Block\Widget\Form\Element\Dependence'
            )->addFieldMap(
                $parentField->getHtmlId(),
                $parentField->getName()
            )->addFieldMap(
                $childField_attribute_lists_add_attr->getHtmlId(),
                $childField_attribute_lists_add_attr->getName()
            )->addFieldMap(
                $childField_removeallfor->getHtmlId(),
                $childField_removeallfor->getName()
            )->addFieldMap(
                $childField_folderlimit->getHtmlId(),
                $childField_folderlimit->getName()
            )->addFieldMap(
                $childField_prod_image_optional->getHtmlId(),
                $childField_prod_image_optional->getName()
            )
            ->addFieldMap(
                $childField_attribute_lists_option_copy->getHtmlId(),
                $childField_attribute_lists_option_copy->getName()
            )
            ->addFieldMap(
                $childField_attribute_reset_lists->getHtmlId(),
                $childField_attribute_reset_lists->getName()
            )->addFieldMap(
                $childField_source_store->getHtmlId(),
                $childField_source_store->getName()
            )->addFieldMap(
                $childField_target_store->getHtmlId(),
                $childField_target_store->getName()
            )->addFieldMap(
                $childField_skus_value_copy->getHtmlId(),
                $childField_skus_value_copy->getName()
            )
           
            ->addFieldMap(
                $childField_ignoredefaults_value_copy->getHtmlId(),
                $childField_ignoredefaults_value_copy->getName()
            )->addFieldMap(
                $childField_store_value_copy_source->getHtmlId(),
                $childField_store_value_copy_source->getName()
            )->addFieldMap(
                $childField_store_value_copy_target->getHtmlId(),
                $childField_store_value_copy_target->getName()
            )->addFieldMap(
                $childField_surcharge->getHtmlId(),
                $childField_surcharge->getName()
            )->addFieldMap(
                $childField_links->getHtmlId(),
                $childField_links->getName()
            )->addFieldMap(
                $childField_add_delete_info->getHtmlId(),
                $childField_add_delete_info->getName()
            )
            ->addFieldMap(
                $childField_type->getHtmlId(),
                $childField_type->getName()
            )->addFieldMap(
                //$childField_store->getHtmlId(),
                $childField_source_store->getHtmlId(),
                //$childField_store->getName()
                $childField_source_store->getName()
            )
            ->addFieldMap(
                $childField_store->getHtmlId(),
                $childField_store->getName()
            )->addFieldMap(
                $childField_source_store->getHtmlId(),
                $childField_source_store->getName()
            )->addFieldMap(
                $childField_nooverride->getHtmlId(),
                $childField_nooverride->getName()
            )
           
            ->addFieldMap(
                $childField_autofill_skus->getHtmlId(),
                $childField_autofill_skus->getName()
            )
            
            ->addFieldMap(
                $childField_update_price_sku->getHtmlId(),
                $childField_update_price_sku->getName()
            )
            ->addFieldMap(
                $childField_autofill_attributesets->getHtmlId(),
                $childField_autofill_attributesets->getName()
            )
            ->addFieldMap(
                $childField_attributeimagedefault_store->getHtmlId(),
                $childField_attributeimagedefault_store->getName()
            )->addFieldMap(
                $childField_attributeimagedefault_optional->getHtmlId(),
                $childField_attributeimagedefault_optional->getName()
            )
            ->addFieldMap(
                $childField_attributeimagedefault_skus->getHtmlId(),
                $childField_attributeimagedefault_skus->getName()
            )->addFieldMap(
                $childField_reset_store->getHtmlId(),
                $childField_reset_store->getName()
            )->addFieldMap(
                $childField_skus->getHtmlId(),
                $childField_skus->getName()
            )->addFieldMap(
                $childField_reset_skus->getHtmlId(),
                $childField_reset_skus->getName()
            )->addFieldMap(
                $childField_removeallfor->getHtmlId(),
                $childField_removeallfor->getName()
            )->addFieldMap(
                $childField_folderlimit->getHtmlId(),
                $childField_folderlimit->getName()
            )->addFieldMap(
                $childField_prod_image_optional->getHtmlId(),
                $childField_prod_image_optional->getName()
            )->addFieldMap(
                $childField_update_prices_store->getHtmlId(),
                $childField_update_prices_store->getName()
            )->addFieldDependence(
                $childField_attribute_lists_add_attr->getName(),
                $parentField->getName(),
                'AddAttributeCommand,add_attribute_lists'
            )->addFieldDependence(
                $childField_attributeimagedefault_store->getName(),
                $parentField->getName(),
                'AttributeimagedefaultCommand,store_default_image'
            )->addFieldDependence(
                $childField_attributeimagedefault_skus->getName(),
                $parentField->getName(),
                'AttributeimagedefaultCommand,skus_default_image'
            )->addFieldDependence(
                $childField_attributeimagedefault_optional->getName(),
                $parentField->getName(),
                'AttributeimagedefaultCommand,default_image_optional'
            )->addFieldDependence(
                //$childField_source_store->getName(),
                $childField_store->getName(),
                $parentField->getName(),
                'AttributeOptionCopyCommand,source_stores'
            )->addFieldDependence(
                $childField_target_store->getName(),
                $parentField->getName(),
                'AttributeOptionCopyCommand,target_stores'
            )->addFieldDependence(
                $childField_attribute_lists_option_copy->getName(),
                $parentField->getName(),
                'AttributeOptionCopyCommand,attribute_lists'
            )->addFieldDependence(
                $childField_nooverride->getName(),
                $parentField->getName(),
                'AttributeOptionCopyCommand,nooverride'
            )->addFieldDependence(
                $childField_reset_store->getName(),
                $parentField->getName(),
                'AttributeresetCommand,reset_store'
            )->addFieldDependence(
                $childField_reset_skus->getName(),
                $parentField->getName(),
                'AttributeresetCommand,reset_skus'
            )->addFieldDependence(
                $childField_attribute_reset_lists->getName(),
                $parentField->getName(),
                'AttributeresetCommand,reset_attribute_lists'
            )->addFieldDependence(
                //$childField_store->getName(),
                $childField_source_store->getName(),
                $parentField->getName(),
                'AttributesAutofillsCommand,source_stores'
            )->addFieldDependence(
                $childField_autofill_skus->getName(),
                $parentField->getName(),
                'AttributesAutofillsCommand,skus'
            )->addFieldDependence(
                $childField_autofill_attributesets->getName(),
                $parentField->getName(),
                'AttributesAutofillsCommand,autofill_attributesets'
            )
          
            ->addFieldDependence(
                $childField_autofill_skus->getName(),
                $parentField->getName(),
                'AttributesAutofillsCommand,autofill_skus'
            )->addFieldDependence(
                $childField_store_value_copy_source->getName(),
                $parentField->getName(),
                'AttributesValueCopyCommand,store_value_copy_source'
            )->addFieldDependence(
                $childField_store_value_copy_target->getName(),
                $parentField->getName(),
                'AttributesValueCopyCommand,store_value_copy_target'
            )->addFieldDependence(
                $childField_skus_value_copy->getName(),
                $parentField->getName(),
                'AttributesValueCopyCommand,skus_value_copy'
            )->addFieldDependence(
                $childField_skus_value_copy->getName(),
                $parentField->getName(),
                'AttributesValueCopyCommand,skus_value_copy'
            )->addFieldDependence(
                $childField_skus_value_copy->getName(),
                $parentField->getName(),
                'AttributesValueCopyCommand,skus_value_copy'
            )->addFieldDependence(
                $childField_skus_value_copy->getName(),
                $parentField->getName(),
                'AttributesValueCopyCommand,skus_value_copy'
            )
           
            ->addFieldDependence(
                $childField_ignoredefaults_value_copy->getName(),
                $parentField->getName(),
                'AttributesValueCopyCommand,ignoredefaults_value_copy'
            )->addFieldDependence(
                $childField_skus->getName(),
                $parentField->getName(),
                'LinkedProductCommand,skus'
            )->addFieldDependence(
                $childField_links->getName(),
                $parentField->getName(),
                'LinkedProductCommand,link'
            )->addFieldDependence(
                $childField_add_delete_info->getName(),
                $parentField->getName(),
                'LinkedProductCommand,add_delete_info'
            )->addFieldDependence(
                $childField_type->getName(),
                $parentField->getName(),
                'LinkedProductCommand,type'
            )->addFieldDependence(
                $childField_prod_image_optional->getName(),
                $parentField->getName(),
                'UpdateattributegroupsCommand,prod_optional'
            )->addFieldDependence(
                $childField_removeallfor->getName(),
                $parentField->getName(),
                'ProductimagesCommand,removeallfor'
            )->addFieldDependence(
                $childField_folderlimit->getName(),
                $parentField->getName(),
                'ProductimagesCommand,folderlimit'
            )->addFieldDependence(
                $childField_prod_image_optional->getName(),
                $parentField->getName(),
                'ProductimagesCommand,prod_optional'
            )->addFieldDependence(
                $childField_update_prices_store->getName(),
                $parentField->getName(),
                'UpdatepricesCommand,store_update_price'
            )->addFieldDependence(
                $childField_surcharge->getName(),
                $parentField->getName(),
                'UpdatepricesCommand,surcharge'
            )->addFieldDependence(
                $childField_update_price_sku->getName(),
                $parentField->getName(),
                'UpdatepricesCommand,update_price_sku'
            )
        );
        
       
        $form->setValues($model ? $model->getData() : '');
        $form->setUseContainer(true);
        $this->setForm($form);
        return parent::_prepareForm();

    }
    

    /**
     * @return Job
     */
    
    protected function getJobObject()
    {
        if ($this->_job === null) {
            $this->_job = $this->_coreRegistry->registry('xtwoshellschedule_shelljob');
        }

        return $this->_job;
    }
    
}