<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Api;

interface PriceInterface
{
    /**
     * @param int $storeId
     * @param array $entityIds
     * @param $limitPerChunk
     * @param $lastEntityId
     * @return array
     */
    public function get($storeId, $entityIds, $limitPerChunk, $lastEntityId);
    
    /**
     * @param int $storeId
     * @param array $productsIdsSamePricesAsDefault
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete($storeId, $productsIdsSamePricesAsDefault);
}
