<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Autoinvoice
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */


namespace Xtwo\Autoinvoice\Observer;

use Magento\Framework\Event\ObserverInterface;
/**
 * Observer to autocreate invoice 
 * 
 */
class OrderObserver implements ObserverInterface
{
    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory
     */
    protected $_invoiceCollectionFactory;

    /**
     * @var \Magento\Sales\Api\InvoiceRepositoryInterface
     */
    protected $_invoiceRepository;

    /**
    * @var \Magento\Sales\Model\Service\InvoiceService
    */
    protected $_invoiceService;

    /**
     * @var \Magento\Framework\DB\TransactionFactory
     */
    protected $_transactionFactory;

    /**
    * @var \Magento\Sales\Api\OrderRepositoryInterface
    */
    protected $_orderRepository;

    /**
    * @param \Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory $invoiceCollectionFactory
    * @param \Magento\Sales\Model\Service\InvoiceService $invoiceService
    * @param \Magento\Framework\DB\TransactionFactory $transactionFactory
    * @param \Magento\Sales\Api\InvoiceRepositoryInterface $invoiceRepository
    * @param \Magento\Sales\Api\OrderRepositoryInterface $orderRepository
    */
    public function __construct(
        \Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory $invoiceCollectionFactory,
        \Magento\Sales\Model\Service\InvoiceService $invoiceService,
        \Magento\Framework\DB\TransactionFactory $transactionFactory,
        \Magento\Sales\Api\InvoiceRepositoryInterface $invoiceRepository,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Psr\Log\LoggerInterface $logger,       
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\Controller\Result\RedirectFactory $resultRedirectFactory,
        \Magento\Sales\Api\Data\TransactionSearchResultInterfaceFactory $tranresfactory
        ) {
          $this->_invoiceCollectionFactory = $invoiceCollectionFactory;
          $this->_invoiceService = $invoiceService;
          $this->_transactionFactory = $transactionFactory;
          $this->_invoiceRepository = $invoiceRepository;
          $this->_orderRepository = $orderRepository;
          $this->logger = $logger;       
          $this->customerSession = $customerSession;
          $this->resultRedirectFactory = $resultRedirectFactory;
          $this->tranresfactory = $tranresfactory;
    }

    /**
     * execute 
     * @param observer
     * @return null
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {   
        $orderId = $observer->getEvent()->getOrder()->getId();
        $order = $observer->getEvent()->getOrder();

        $this->logger->critical('Order Status: '.$order->getStatus());
        
       
        $payment = $observer->getEvent()->getOrder()->getPayment();
        $method = $payment->getMethodInstance();
        $methodTitle = $method->getCode();

        if($methodTitle){        
    
    
         $paid = 0;
         $tranid = '';
        if($methodTitle == 'payone_creditcard'){
      
         // die();
         if($methodTitle == 'payone_creditcard'){
           $tranid = (int)$observer->getEvent()->getOrder()->getPayoneTxid();
         }

         $tranid = str_replace("[]","",$tranid);
         $methodTitle = str_replace("[]","",$methodTitle);
       
         
        
        if($methodTitle == 'payone_creditcard' && $tranid != ''){
            $paid = 1;   
        }
     }

       // to check from admin after successfull invoice status should be processing
       if($methodTitle == 'payone_creditcard' && $paid == 1){
          //  $this->logger->critical('invoice creation fails for payone: '.$tranid.' method:'.$methodTitle);
            $this->createInvoicePayone($orderId);
        }
    } else {
        $this->logger->critical('No method');
    }
   
}

    protected function createInvoicePayone($orderId)
    {
        try 
        {
            $order = $this->_orderRepository->get($orderId);
            if ($order)
            {
                $invoices = $this->_invoiceCollectionFactory->create()->addAttributeToFilter('order_id', array('eq' => $order->getId()));
             
                $invoices->getSelect()->limit(1);

                if ((int)$invoices->count() !== 0) {
                  $invoices = $invoices->getFirstItem();
                  $invoice = $this->_invoiceRepository->get($invoices->getId());
                  return $invoice;
                }
             
                if(!$order->canInvoice()) {
                    return null;
                }

                $invoice = $this->_invoiceService->prepareInvoice($order);
                // $invoice->setRequestedCaptureCase(\Magento\Sales\Model\Order\Invoice::CAPTURE_ONLINE);
                $invoice->setRequestedCaptureCase(\Magento\Sales\Model\Order\Invoice::NOT_CAPTURE);
               // $this->logger->critical(3);
                $invoice->register();
             
                // $invoice->getOrder()->setCustomerNoteNotify(false);
                $invoice->setTransactionId($order->getPayment()->getLastTransId());             
                $invoice->getOrder()->setIsInProcess(true);
                $order->addStatusHistoryComment(__('Automatically INVOICED'), false);               
                $transactionSave = $this->_transactionFactory->create()->addObject($invoice)->addObject($invoice->getOrder());
                // $this->logger->critical(8);
                $transactionSave->save();
                $this->logger->critical(9);
                return $invoice;
            }
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
            throw new \Magento\Framework\Exception\LocalizedException(
                __($e->getMessage())
            );
        }
    }
}