<?php
namespace Xtwo\AutoFillSearch\Model;

use Xtwo\AutoFillSearch\Api\PopularSearch;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

class PopularSearchData implements PopularSearch
{
    protected $_collectionFactory;
    protected $scopeConfig;

    public function __construct(
        \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $collecionFactory,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->_collectionFactory = $collecionFactory;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @inheritdoc
     */
    public function getPopularSearch()
    {
        $isEnabled = $this->scopeConfig->getValue('searchautocomplete/popular/enabled', ScopeInterface::SCOPE_WEBSITE);
        $popularDatas = $this->scopeConfig->getValue('searchautocomplete/popular/default', ScopeInterface::SCOPE_STORE);
        if($isEnabled == 1 && $popularDatas != null){
            $popularDataArray = [];
            $popularItems = explode(',', $popularDatas);
            foreach ($popularItems as $item) {
                $popularCategoryLink = $this->_collectionFactory
                            ->create()
                            ->addAttributeToSelect('url_key')
                            ->addAttributeToFilter('name', $item)
                            ->getFirstItem()
                            ->getUrlKey();
                $finalPolpularData = [
                    'name' => $item,
                    'link' => $popularCategoryLink
                ];
                $popularDataArray[] = $finalPolpularData;
            }

            return $popularDataArray;
        }else{
            return [];

        }
    }
}
