<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\AttributeOption\Ui\DataProvider;

use Magento\Backend\Model\Session;
use Magento\Framework\Filesystem;
use Magento\Framework\Registry;
use Magento\Ui\DataProvider\AbstractDataProvider;
use Xtwo\AttributeOption\Model\ImageFactory;
use Xtwo\AttributeOption\Model\ResourceModel\Image\CollectionFactory;
use Magento\Ui\DataProvider\Modifier\PoolInterface;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Xtwo\AttributeOption\Model\Image;

class ImageDataProvider extends AbstractDataProvider
{
    /**
     * @var \Magento\Ui\DataProvider\Modifier\PoolInterface
     */
    private $pool;
    /**
     * @var \Magento\Framework\Registry
     */
    private $coreRegistry;
    /**
     * @var \Xtwo\AttributeOption\Model\ImageFactory
     */
    private $imageFactory;
    /**
     * @var \Magento\Backend\Model\Session
     */
    private Session $session;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private UrlInterface $urlBuilder;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param CollectionFactory $imageCollectionFactory
     * @param \Magento\Ui\DataProvider\Modifier\PoolInterface $pool
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Xtwo\AttributeOption\Model\ImageFactory $imageFactory
     * @param \Magento\Backend\Model\Session $session
     * @param \Magento\Framework\UrlInterface $urlBuilder
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $imageCollectionFactory,
        PoolInterface $pool,
        Registry $coreRegistry,
        ImageFactory $imageFactory,
        Session $session,
        UrlInterface $urlBuilder,
        Filesystem $filesystem,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $imageCollectionFactory->create();
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->pool = $pool;
        $this->coreRegistry = $coreRegistry;
        $this->imageFactory = $imageFactory;
        $this->session = $session;
        $this->urlBuilder = $urlBuilder;
        $this->mediaDirectory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);
    }

    /**
     * @inheritdoc
     */
    public function getData()
    {
        if (isset($this->_loadedData)) {
            return $this->_loadedData;
        }
        $imageData = $this->coreRegistry->registry('image');
        if (!is_null($imageData) && $imageData->getId()) {
            $image = $this->imageFactory->create();
            $image->load($imageData->getId());

            $imageName = $image->getFileName();

            if (file_exists($this->mediaDirectory->getAbsolutePath(Image::PATH_TO_LOGO . $image->getId() .'/' . $imageName))) {

                $image->setImage(
                    [
                        0 =>
                            [
                                'name' => $imageName,
                                'url' => $this->urlBuilder->getBaseUrl(
                                        ['_type' => UrlInterface::URL_TYPE_MEDIA]
                                    ) . Image::PATH_TO_LOGO . $image->getId().'/'  . $imageName,
                                'type' => mime_content_type(
                                    $this->mediaDirectory->getAbsolutePath(
                                        Image::PATH_TO_LOGO . $image->getId() .'/'  . $imageName
                                    )
                                ),
                                'size' => filesize(
                                    $this->mediaDirectory->getAbsolutePath(
                                        Image::PATH_TO_LOGO . $image->getId() .'/'  . $imageName
                                    )
                                ),
                            ],
                    ]
                );
            }

            $this->_loadedData[$image->getId()] = $image->getData();

            return $this->_loadedData;
        } elseif ($this->session->getPageData()) {
            $this->_loadedData[null] = $this->session->getPageData();
            $this->session->setPageData(false);

            return $this->_loadedData;
        }

        return [];
    }

    /**
     * {@inheritdoc}
     * @since 101.0.0
     */
    public function getMeta()
    {
        $meta = parent::getMeta();

        /** @var ModifierInterface $modifier */
        foreach ($this->pool->getModifiersInstances() as $modifier) {
            $meta = $modifier->modifyMeta($meta);
        }

        return $meta;
    }
}
