<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\AttributeOption\Ui\Component\Listing\Columns;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Xtwo\AttributeOption\Helper\OptionValue;
use Xtwo\AttributeOption\Model\ResourceModel\Image\Collection;

class OptionValueColumn extends Column
{
    private OptionValue $optionValueHelper;
    private Collection $imageCollection;

    /**
     * @param \Magento\Framework\View\Element\UiComponent\ContextInterface $context
     * @param \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory
     * @param \Xtwo\AttributeOption\Helper\OptionValue $optionValueHelper
     * @param \Xtwo\AttributeOption\Model\ResourceModel\Image\Collection $imageCollection
     * @param array $components = []
     * @param array $data = []
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        OptionValue $optionValueHelper,
        Collection $imageCollection,
        array $components = [],
        array $data = []
    ){
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->optionValueHelper = $optionValueHelper;
        $this->imageCollection = $imageCollection;
    }

    /**
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        $this->imageCollection->addFieldToSelect('attribute_id')
            ->getSelect()->group('attribute_id');

        $itemsAdminStoreLabels = $attributeIds = [];
        foreach ($this->imageCollection->getItems() as $image) {
            $attributeIds[] = $image->getAttributeId();
        }
        foreach ($this->optionValueHelper->getAllOptions($attributeIds)->getItems() as $itemAdminStore) {
            $itemsAdminStoreLabels[$itemAdminStore->getOptionId()] = $itemAdminStore->getValue();
        }

        if (isset($dataSource['data']['items'])){
            foreach($dataSource['data']['items'] as &$item){
                $item['option_value'] = !empty($item['option_value'])
                    ? $item['option_value']
                    : $itemsAdminStoreLabels[$item['option_id']];
            }
        }

        return $dataSource;
    }
}
