<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\AttributeOption\Plugin;

use Magento\Catalog\Api\Data\ProductAttributeInterface;
use Magento\Catalog\Controller\Adminhtml\Product\Attribute\Save;
use Magento\Catalog\Model\ResourceModel\Eav\AttributeFactory;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Serialize\Serializer\FormData;
use Xtwo\AttributeOption\Api\ImageRepositoryInterface;
use Xtwo\AttributeOption\Helper\Image;

class CatalogControllerAdminhtmlProductAttributeSavePlugin
{
    /**
     * @var \Magento\Framework\Serialize\Serializer\FormData|null
     */
    private ?FormData $formDataSerializer;
    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private RequestInterface $request;
    /**
     * @var \Magento\Catalog\Model\ResourceModel\Eav\AttributeFactory
     */
    private AttributeFactory $attributeFactory;
    /**
     * @var \Xtwo\AttributeOption\Api\ImageRepositoryInterface
     */
    private ImageRepositoryInterface $imageRepository;
    /**
     * @var \Xtwo\AttributeOption\Helper\Image
     */
    private Image $imageHelper;

    /**
     * CatalogControllerAdminhtmlProductAttributeSavePlugin constructor.
     *
     * @param \Magento\Framework\App\RequestInterface $request
     * @param \Magento\Framework\Serialize\Serializer\FormData|null $formDataSerializer
     * @param \Magento\Catalog\Model\ResourceModel\Eav\AttributeFactory $attributeFactory
     * @param \Xtwo\AttributeOption\Api\ImageRepositoryInterface $imageRepository
     * @param \Xtwo\AttributeOption\Helper\Image $imageHelper
     */
    public function __construct(
        RequestInterface $request,
        FormData $formDataSerializer,
        AttributeFactory $attributeFactory,
        ImageRepositoryInterface $imageRepository,
        Image $imageHelper
    ) {
        $this->formDataSerializer = $formDataSerializer;
        $this->request = $request;
        $this->attributeFactory = $attributeFactory;
        $this->imageRepository = $imageRepository;
        $this->imageHelper = $imageHelper;
    }

    public function afterExecute(Save $subject, $result)
    {
        $optionData = $this->formDataSerializer
            ->unserialize($this->getRequest()->getParam('serialized_options', '[]'));

        $attributeId = $this->getRequest()->getParam('attribute_id');
        /** @var ProductAttributeInterface $model */
        $model = $this->attributeFactory->create();
        if ($attributeId) {
            $model->load($attributeId);
        }

        if ($model->getAttributeCode() != 'attributeoption')  {
            return $result;
        }

        $options = $toDelete = [];
        foreach ($optionData['option']['value'] as $key => $option) {
            $options[$key] = strip_tags($option[0]);
        }

        $toDelete = [];
        if (!empty($optionData['option']['delete'])) {
            foreach ($optionData['option']['delete'] as $optionId => $value) {
                if ($value == 1) {
                    $toDelete[] = $optionId;
                }
            }

            $images = $this->imageHelper->filterByOptionId($toDelete);

            foreach ($images as $image) {
                if (in_array($image->getOptionId(), array_keys($options))
                    && $image->getOptionValue() == $options[$image->getOptionId()]) {
                    $this->imageRepository->deleteById($image->getId());
                }
            }
        }

        return $result;
    }

    /**
     * Retrieve request object
     *
     * @return \Magento\Framework\App\RequestInterface
     */
    public function getRequest()
    {
        return $this->request;
    }
}
