<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace  Xtwo\AttributeOption\Model;

use Magento\Framework\Registry;

/**
 * Class Mapper
 *
 * @package Xtwo\AttributeOption\Model
 */
class Mapper
{
    /** @var array */
    public $map;

    /** @var \Magento\Catalog\Model\ResourceModel\Eav\Attribute[] */
    private $attributes;
    private Registry $coreRegistry;
    /**
     * @var \Xtwo\AttributeOption\Model\ImageFactory
     */
    private ImageFactory $imageFactory;

    /**
     * @param \Xtwo\AttributeOption\Model\Attribute $attributes
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Xtwo\AttributeOption\Model\ImageFactory $imageFactory
     */
    public function __construct(
        Attribute $attributes,
        Registry $coreRegistry,
        ImageFactory $imageFactory
    ) {
        $this->attributes = $attributes;
        $this->coreRegistry = $coreRegistry;
        $this->imageFactory = $imageFactory;
        $this->map = $this->makeMap();
    }

    /**
     * @return array
     */
    private function makeMap()
    {
        if (is_null($this->map)) {
            $this->map = $this->buildMap();
        }

        return $this->map;
    }

    /**
     * @return array
     */
    private function buildMap()
    {
        $imageData = $this->coreRegistry->registry('image');

        if (!is_null($imageData) && $imageData->getId()) {
            $image = $this->imageFactory->create();
            $image->load($imageData->getId());
            $items = [
                'selected' => $image->getOptionId()
            ];
        }

        foreach ($this->attributes->getAttributes() as $attribute) {
            $options = [];
            foreach ($attribute->getOptions() as $option) {
                if (empty($option->getValue())) {
                    continue;
                }
                $options[] = [
                    'label' => strip_tags($option->getLabel()),
                    'value' => $option->getValue(),
                ];
            }
            $items[$attribute->getId()] = $options;
        }

        return $items;
    }
}
