<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace  Xtwo\AttributeOption\Model;


use Magento\Framework\Model\Context;
use Magento\Framework\Registry;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Data\Collection\AbstractDb;

use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractModel;



use Magento\Framework\Stdlib\DateTime\DateTimeFactory;

class Image
    extends AbstractModel
    implements IdentityInterface
{
    const CACHE_TAG = 'xtwo_attributeoption_image';

    const PATH_TO_LOGO = 'attributeoption/image/';

    /**
     * Company constructor.
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null $resourceCollection
     * @param \Magento\Framework\Stdlib\DateTime\DateTimeFactory $dateFactory
     * @param array $data
     */


    public function __construct(
        DateTimeFactory $dateFactory,
        Context $context,
        Registry $registry,
        AbstractResource $resource = null,   
        AbstractDb $resourceCollection = null,
        array $data = [])
    {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);

        $this->dateFactory = $dateFactory;
    }



    /**
     * @return string[]
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    protected function _construct()
    {
        $this->_init('Xtwo\AttributeOption\Model\ResourceModel\Image');
    }

}
