<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace  Xtwo\AttributeOption\Model\Data;

use Magento\Framework\Api\AbstractSimpleObject;
use  Xtwo\AttributeOption\Api\Data\ImageInterface;

class Image extends AbstractSimpleObject implements ImageInterface
{
    /**
     * @inheridoc
     */
    public function getId()
    {
        return $this->_get(self::ID);
    }

    /**
     * @inheridoc
     */
    public function setId($value)
    {
        $this->setData(self::ID, $value);

        return $this;
    }

    /**
     * @inheridoc
     */
    public function getOptionId()
    {
        return $this->_get(self::OPTION_ID);
    }

    /**
     * @inheridoc
     */
    public function setOptionId(int $value)
    {
        $this->setData(self::OPTION_ID, $value);

        return $this;
    }

    /**
     * @inheridoc
     */
    public function getFileName()
    {
        return $this->_get(self::FILE_NAME);
    }

    /**
     * @inheridoc
     */
    public function setFileName(string $value)
    {
        $this->setData(self::FILE_NAME, $value);

        return $this;
    }

    /**
     * @inheridoc
     */
    public function getAttributeId()
    {
        return $this->_get(self::ATTRIBUTE_ID);
    }

    /**
     * @inheridoc
     */
    public function setAttributeId(int $value)
    {
        $this->setData(self::ATTRIBUTE_ID, $value);

        return $this;
    }

    /**
     * @inheridoc
     */
    public function getStoreId()
    {
        return $this->_get(self::STORE_ID);
    }

    /**
     * @inheridoc
     */
    public function setStoreId(String $value)
    {
        $this->setData(self::STORE_ID, $value);

        return $this;
    }
}
