<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace  Xtwo\AttributeOption\Model;

use Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory;
use Magento\Framework\Option\ArrayInterface;

/**
 * Class AttributeOptions
 *
 * @package Xtwo\AttributeOption\Model\Example
 */
class Attribute implements ArrayInterface
{
    /** @var \Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory */
    private $collectionFactory;

    /** @var \Xtwo\AttributeOption\Model\AttributeScope */
    private $scope;

    /** @var array */
    private $items;

    /**
     * @param \Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory $collectionFactory
     * @param \Xtwo\AttributeOption\Model\AttributeScope $scope
     */
    public function __construct(
        CollectionFactory $collectionFactory,
        AttributeScope $scope
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->scope = $scope;
    }

    /**
     * @inheritdoc
     */
    public function toOptionArray()
    {
        if (is_null($this->items)) {
            $this->items = $this->getOptions();
        }

        return $this->items;
    }

    /**
     * @return array
     */
    private function getOptions()
    {
        $items = [];
        foreach ($this->getAttributes() as $attribute) {
            $items[] = [
               // 'label' => strip_tags($attribute->getStoreLabel()), 'value' => $attribute->getId(),
                'label' => $attribute->getStoreLabel()?strip_tags($attribute->getStoreLabel()):'', 'value' => $attribute->getId(),
            ];
        }
        return $items;
    }

    /**
     * @return \Magento\Catalog\Model\ResourceModel\Eav\Attribute[]|\Magento\Framework\DataObject[]
     */
    public function getAttributes()
    {
        $codes = $this->scope->getCodes();
        $collection = $this->getCollection();
        if (!empty($codes)) {
            $collection->addFieldToFilter('attribute_code', $codes);
            $collection->addFieldToFilter('frontend_input', 'select');
        }
        return $collection->getItems();
    }


    /**
     * @return \Magento\Catalog\Model\ResourceModel\Product\Attribute\Collection
     */
    private function getCollection()
    {
        return $this->collectionFactory->create();
    }
}
