<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\AttributeOption\Helper;

use Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\Collection;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;

class OptionValue extends AbstractHelper
{
    /**
     * @var \Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\Collection
     */
    private Collection $optionCollection;
    /**
     * @var \Magento\Framework\App\Helper\Context
     */
    private Context $context;

    /**
     * OptionValue helper.
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\Collection $optionCollection
     */
    public function __construct(
        Context $context,
        Collection $optionCollection
    ) {

        parent::__construct($context);

        $this->optionCollection = $optionCollection;
        $this->context = $context;
    }

    /**
     * @param array $attributeIds
     *
     * @return \Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\Collection
     */
    public function getAllOptions($attributeIds)
    {
        return $this->optionCollection->setStoreFilter(0)
            ->setAttributeFilter($attributeIds);
    }
}

?>
