<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace  Xtwo\AttributeOption\Helper;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Registry;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Api\FilterBuilder;
use Xtwo\AttributeOption\Repository\ImageRepository;
use Magento\Framework\Filesystem;
use Magento\Framework\App\Filesystem\DirectoryList;

class Image extends AbstractHelper
{
    private Registry $registry;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private ProductRepositoryInterface $productRepository;
    /**
     * @var \Xtwo\AttributeOption\Repository\ImageRepository
     */
    private ImageRepository $imageRepository;
    /**
     * @var \Magento\Framework\Api\SearchCriteriaBuilder
     */
    private SearchCriteriaBuilder $searchCriteriaBuilder;
    /**
     * @var \Magento\Framework\Api\FilterBuilder
     */
    private FilterBuilder $filterBuilder;
    /**
     * @var \Xtwo\Catalog\Model\Configurable
     */
    private \Xtwo\Catalog\Model\Configurable $catalogProductTypeConfigurable;

    /**
     * @var array
     */
    private $layerImagesOfSimples = [];
    /**
     * @var \Magento\Framework\App\Helper\Context
     */
    private Context $context;

    protected $mediaDirectory;

    /**
     * Shipping constructor.
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     * @param \Xtwo\AttributeOption\Repository\ImageRepository $imageRepository
     * @param \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder
     * @param \Magento\Framework\Api\FilterBuilder $filterBuilder
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Xtwo\Catalog\Model\Configurable $catalogProductTypeConfigurable
     */
    public function __construct(
        Context $context,
        Registry $registry,
        ProductRepositoryInterface $productRepository,
        ImageRepository $imageRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder,
        ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        Filesystem $filesystem
    ) {
        $this->registry = $registry;
        $this->productRepository = $productRepository;
        parent::__construct($context);

        $this->imageRepository = $imageRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->filterBuilder = $filterBuilder;
        $this->scopeConfig = $scopeConfig;
        $this->context = $context;
        $this->_storeManager = $storeManager;
        $this->mediaDirectory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);

    }

    /**
     * @param \Magento\Catalog\Api\Data\ProductInterface $product
     *
     * @return string
     */
    public function getManufacturerImage($product = null)
    {
        if (empty($product)) {
            $product = $this->getProduct();
        }
        //dd($product->getManufacturer());
        foreach ($this->filterByOptionId($product->getManufacturer()) as $image) {
            return $image->getId() . '/' . $image->getFileName();
        }

    }

    /**
     * @param \Magento\Catalog\Api\Data\ProductInterface $product
     *
     * @return string
     */
    public function getLayerImage($optionId)
    {
        return $this->getLayerImageByOptionId($optionId);
    }

    /**
     * @param int $optionId
     *
     * @return string
     */
    public function getLayerImageByOptionId($optionId)
    {
        $currentStoreId = $this->_storeManager->getStore()->getId();
        $storesIds=[];
        foreach ($this->filterByOptionId($optionId) as $image) {
            if(!empty($image->getStoreId())){
                $storesIds= explode(',',$image->getStoreId());
            }
            if(!empty($storesIds) && in_array($currentStoreId,$storesIds)){
                return $image->getId() . '/' . $image->getFileName();
            }else{
                return false;
            }

        }
    }

    /**
     * @param array|int $optionId
     *
     * @return \Xtwo\AttributeOption\Api\Data\ImageInterface[]
     */
    public function filterByOptionId($optionId)
    {
        $this->searchCriteriaBuilder->addFilters(
            [
                $this->filterBuilder
                    ->setField('option_id')
                    ->setConditionType(is_array($optionId) ? 'in' : 'eq')
                    ->setValue($optionId)
                    ->create(),

                    $this->filterBuilder
                    ->setField('store_id')
                    ->setConditionType('eq')
                    ->setValue($this->_storeManager->getStore()->getId())
                    // ->setValue(3)
                    ->create(),

            ]
        );


        //@TODO store filter?
        $this->searchCriteriaBuilder->setPageSize(1000);

        $searchCriteria = $this->searchCriteriaBuilder->create();

        return $this->imageRepository->getList($searchCriteria)->getItems();
    }

    /**
     * @return Product
     */
    protected function getProduct()
    {
        $product = $this->registry->registry('current_product');
        if (!$product) {
            $product = $this->registry->registry('product');
        }
        if ($product) {
            if ($defaultId = $product->getData('default_configuration_id')) {
                $product = $this->productRepository->getById($defaultId);
            }
        }

        return $product;
    }

    /**
     * @return array
     */
    public function getConfigurationValuesDetailsPage()
    {
        return [
                'enable' => $this->scopeConfig->getValue(
                    'xtwo_attributeoption/layer_image_base/enable_in_product_detail_page'
                ),
            ] + $this->getConfiguration('layer_image_base');
    }

    /**
     * @return array
     */
    public function getConfigurationValuesListPage()
    {
        return [
                'enable' => $this->scopeConfig->getValue(
                    'xtwo_attributeoption/layer_image_base/enable_in_product_list_page'
                ),
            ] + $this->getConfiguration('layer_image_small');
    }

    /**
     * @param string $path
     *
     * @return array
     */
    protected function getConfiguration($path)
    {
        return [
            'width' => $this->scopeConfig->getValue('xtwo_attributeoption/' . $path . '/width'),
            'height' => $this->scopeConfig->getValue('xtwo_attributeoption/' . $path . '/height'),
            'offset_top' => $this->scopeConfig->getValue('xtwo_attributeoption/' . $path . '/suggest_offset_top'),
            'offset_left' => $this->scopeConfig->getValue('xtwo_attributeoption/' . $path . '/suggest_offset_left'),
            'enable_offset' => $this->scopeConfig->getValue('xtwo_attributeoption/' . $path . '/enable_offset'),
        ];
    }
    public function getConfig($config_path)
    {
        return $this->scopeConfig->getValue(
            $config_path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
    /*
    * Get option image full url
    */
    public function getAttributeOptionImageFullUrl($image) {
        $path = "attributeoption/image/";
        $mediaUrl=$this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);

        if ($this->mediaDirectory->isFile($path. $image)) {
            return $mediaUrl.$path.$image;
        }else{
            return false;
        }

    }
}

?>
