<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\AttributeOption\Controller\Adminhtml\Image;

use Exception;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Catalog\Model\ResourceModel\ProductFactory;
use Magento\Eav\Model\Entity\AttributeFactory;
use Magento\Eav\Model\ResourceModel\Entity\Attribute;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Io\File;
use Psr\Log\LoggerInterface;
use Xtwo\AttributeOption\Api\Data\ImageInterfaceFactory;
use Xtwo\AttributeOption\Model\Image;
use Xtwo\AttributeOption\Model\ImageUploader;
use Xtwo\AttributeOption\Repository\ImageRepository;
use Xtwo\AttributeOption\Helper\Image as ImageHelper;

use Magento\Eav\Api\AttributeRepositoryInterface;

/**
 * Class Save
 *
 * @package Xtwo\AttributeOption\Controller\Adminhtml\Image
 */
class Save extends Action
{
    /**
     * @var \Xtwo\AttributeOption\Repository\ImageRepository
     */
    private $imageRepository;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;
    /**
     * @var \Xtwo\AttributeOption\Api\Data\ImageInterfaceFactory
     */
    private ImageInterfaceFactory $imageDataFactory;
    /**
     * @var \Xtwo\AttributeOption\Model\ImageUploader
     */
    private ImageUploader $imageUploader;
    /**
     * @var \Magento\Catalog\Model\ResourceModel\ProductFactory
     */
    private ProductFactory $productFactory;
    /**
     * @var \Magento\Framework\Filesystem\Io\File
     */
    private File $file;
    /**
     * @var \Magento\Framework\Filesystem\DirectoryList
     */
    private DirectoryList $dir;
    /**
     * @var \Xtwo\AttributeOption\Helper\Image
     */
    private ImageHelper $imageHelper;
    /**
     * @var \Magento\Eav\Api\AttributeRepositoryInterface
     */
    private AttributeRepositoryInterface $attributeRepository;
    /**
     * @var \Magento\Eav\Model\Entity\AttributeFactory
     */
    private AttributeFactory $attributeFactory;
    /**
     * @var \Magento\Eav\Model\ResourceModel\Entity\Attribute
     */
    private Attribute $eavResource;

    /**
     * Save constructor.
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Xtwo\AttributeOption\Repository\ImageRepository $imageRepository
     * @param \Xtwo\AttributeOption\Api\Data\ImageInterfaceFactory $imageDataFactory
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Xtwo\AttributeOption\Model\ImageUploader $imageUploader
     * @param \Magento\Catalog\Model\ResourceModel\ProductFactory $productFactory
     * @param \Magento\Framework\Filesystem\Io\File $file
     * @param \Magento\Framework\Filesystem\DirectoryList $dir
     * @param \Xtwo\AttributeOption\Helper\Image $imageHelper
     * @param \Magento\Eav\Api\AttributeRepositoryInterface $attributeRepository
     * @param \Magento\Eav\Model\Entity\AttributeFactory $attributeFactory
     * @param \Magento\Eav\Model\ResourceModel\Entity\Attribute $eavResource
     */
    public function __construct(
        Context $context,
        ImageRepository $imageRepository,
        ImageInterfaceFactory $imageDataFactory,
        LoggerInterface $logger,
        ImageUploader $imageUploader,
        ProductFactory $productFactory,
        File $file,
        DirectoryList $dir,
        ImageHelper $imageHelper,
        AttributeRepositoryInterface $attributeRepository,
        AttributeFactory $attributeFactory,
        Attribute $eavResource
    ) {
        parent::__construct($context);

        $this->imageRepository = $imageRepository;
        $this->logger = $logger;
        $this->imageDataFactory = $imageDataFactory;
        $this->imageUploader = $imageUploader;
        $this->productFactory = $productFactory;
        $this->file = $file;
        $this->dir = $dir;
        $this->imageHelper = $imageHelper;
        $this->attributeRepository = $attributeRepository;
        $this->attributeFactory = $attributeFactory;
        $this->eavResource = $eavResource;
    }

    public function execute()
    {

    
        if ($this->getRequest()->getPostValue()) {
            try {
                $data = $this->getRequest()->getPostValue();

                $id = $this->getRequest()->getParam('entity_id');
                if ($id !== null) {
                    $image = $this->imageRepository->getById((int)$id);
                } else {
                    $image = $this->imageDataFactory->create();
                }

            
                /*
                // same attribute may be assigned to different store 
                if (count($this->imageHelper->filterByOptionId($data['option_id'])) > 0
                    && (int) $image->getOptionId() != (int) $data['option_id']) {
                    throw new LocalizedException(__("The image for such  has been already assigned"));
                }*/

                $oldFileName = $image->getFileName();

              
                $image->setFileName(!empty($oldFileName) ? $oldFileName : '');
                $image->setOptionId($data['option_id']);
                $image->setAttributeId($data['attribute_id']);
                //$image->setStoreId($data['store_id']);
                $image->setStoreId(implode(',',$data['store_id']));
                


                $image = $this->imageRepository->save($image);

                

                if (isset($data['image']['delete'])) { //@TODO
                    $data['image'] = null;
                }

                if (isset($data['image'][0]['tmp_name'])) {
                    $image->setFileName($this->saveImage($data['image'], $oldFileName, $image->getId()));
                    $this->imageRepository->save($image);
                }

                $this->messageManager->addSuccessMessage(__('You saved the image.'));

                if ($this->getRequest()->getParam('back')) {
                    $this->_redirect('*/*/edit', ['id' => $image->getId()]);

                    return;
                }
                $this->_redirect('*/*/');

                return;
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                $id = (int)$this->getRequest()->getParam('id');
                $this->_session->setPageData($data);
                $this->_redirect('*/*/edit', (!empty($id) ? ['id' => $id] : []));

                return;
            } catch (Exception $e) {
                $this->messageManager->addErrorMessage(
                    __('Something went wrong while saving the image data. Please review the error log.')
                );
                $this->logger->critical($e);
                $this->_session->setPageData($data);
                $this->_redirect('*/*/edit', ['id' => $this->getRequest()->getParam('id')]);

                return;
            }
        }
        $this->_redirect('*/*/');
    }

    /**
     * @param array $fileData
     * @param int $id
     */
    protected function saveImage($fileData, $oldFileName, $id)
    {
        $path = $this->dir->getPath('media') . '/' . Image::PATH_TO_LOGO . $id;
        if (!file_exists($path)) {
            $this->file->mkdir($path,0777,1);
        }

        $this->file->rm($path . '/' . $oldFileName);

        return $this->imageUploader->moveFileFromTmpToPath($fileData[0]['name'], '/' . $id . '/');
    }
}