<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\AttributeOption\Controller\Adminhtml\Image;

use Exception;
use Magento\Backend\App\Action;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Io\File;
use Psr\Log\LoggerInterface;
use Xtwo\AttributeOption\Model\Image;
use Xtwo\AttributeOption\Repository\ImageRepository;

/**
 * Class MassDelete
 *
 * @package Xtwo\AttributeOption\Controller\Adminhtml\Image
 */
class MassDelete extends Action implements HttpPostActionInterface
{
    /**
     * @var \Xtwo\AttributeOption\Repository\ImageRepository
     */
    private $companyRepository;
    /**
     * @var \Magento\Framework\Api\SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;
    /**
     * @var \Magento\Framework\Api\FilterBuilder
     */
    private $filterBuilder;

    /**
     * Delete constructor.
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Xtwo\AttributeOption\Repository\ImageRepository $imageRepository
     * @param \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder
     * @param \Magento\Framework\Api\FilterBuilder $filterBuilder
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(
        Action\Context $context,
        ImageRepository $imageRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder,
        LoggerInterface $logger
    ) {
        parent::__construct($context);
        $this->imageRepository = $imageRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->logger = $logger;
        $this->filterBuilder = $filterBuilder;
    }

    /**
     * Delete image action
     *
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute()
    {
        $imageIds = $this->getRequest()->getParam('selected');

        if (is_array($imageIds)) {
            $this->searchCriteriaBuilder->addFilters(
                [
                    $this->filterBuilder
                        ->setField('main_table.entity_id')
                        ->setConditionType('in')
                        ->setValue($imageIds)
                        ->create(),
                ]
            );

            $this->searchCriteriaBuilder->setPageSize(100);
            $searchCriteria = $this->searchCriteriaBuilder->create();
            $result = $this->imageRepository->getList($searchCriteria);

            foreach ($result->getItems() as $image) {
                try {
                    $this->imageRepository->deleteById($image->getId());

                } catch (LocalizedException $e) {
                    $this->messageManager->addErrorMessage($e->getMessage());
                    $this->logger->error($e->getMessage());
                } catch (Exception $e) {
                    $this->messageManager->addErrorMessage(
                        __('We can\'t delete the company right now. Please review the log and try again.')
                    );
                    $this->logger->error($e->getMessage());
                    $this->_redirect(
                        'xtwo_attributeoption/image/'
                    );
                }
            }
        }

        $this->messageManager->addSuccessMessage(__('You deleted the image(-s).'));
        $this->_redirect('xtwo_attributeoption/image/');
    }
}
