<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\AttributeOption\Controller\Adminhtml\Image;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Registry;
use Xtwo\AttributeOption\Repository\ImageRepository;

/**
 * Class Edit
 * @package Xtwo\AttributeOption\Controller\Adminhtml\Image
 */
class Edit extends Action
{
    /**
     * @var \Xtwo\AttributeOption\Repository\ImageRepository
     */
    private $imageRepository;
    /**
     * @var \Magento\Framework\Registry
     */
    private $coreRegistry;

    /**
     * Edit constructor.
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Xtwo\AttributeOption\Repository\ImageRepository $companyRepository
     * @param \Magento\Framework\Registry $coreRegistry
     */
    public function __construct(Action\Context $context,
                                ImageRepository $imageRepository,
                                Registry $coreRegistry)
    {
        parent::__construct($context);
        $this->imageRepository = $imageRepository;
        $this->coreRegistry = $coreRegistry;
    }

    /**
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');

        if (!empty($id)) {
            $image = $this->imageRepository->getById($id);
            $this->coreRegistry->register('image', $image);
        }

        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        return $resultPage;
    }
}
