<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\AttributeOption\Controller\Adminhtml\Image;

use Exception;
use Magento\Backend\App\Action;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Io\File;
use Psr\Log\LoggerInterface;
use Xtwo\AttributeOption\Model\Image;
use Xtwo\AttributeOption\Repository\ImageRepository;

/**
 * Class Delete
 *
 * @package Xtwo\AttributeOption\Controller\Adminhtml\Image
 */
class Delete extends Action
{
    /**
     * @var \Xtwo\AttributeOption\Repository\ImageRepository
     */
    private $imageRepository;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;

    /**
     * Delete constructor.
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Xtwo\AttributeOption\Repository\ImageRepository $imageRepository
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(
        Action\Context $context,
        ImageRepository $imageRepository,
        LoggerInterface $logger
    ) {
        parent::__construct($context);

        $this->imageRepository = $imageRepository;
        $this->logger = $logger;
    }

    /**
     * Delete image action
     *
     * @return void
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');

        if (!empty($id)) {
            try {
                $this->imageRepository->deleteById($id);

                $this->messageManager->addSuccessMessage(__('You deleted the image.'));
                $this->_redirect('xtwo_attributeoption/image/');

                return;
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                $this->logger->error($e->getMessage());
            } catch (Exception $e) {
                $this->messageManager->addErrorMessage(
                    __('We can\'t delete the image right now. Please review the log and try again.')
                );
                $this->logger->error($e->getMessage());
                $this->_redirect(
                    'xtwo_attributeoption/image/edit',
                    ['id' => $this->getRequest()->getParam('id')]
                );

                return;
            }
        }
        $this->messageManager->addErrorMessage(__('We can\'t find a image to delete.'));
        $this->_redirect('xtwo_attributeoption/image/');
    }
}
