<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\AttributeOption\Api;

use Magento\Framework\Api\SearchCriteriaInterface;
use Xtwo\AttributeOption\Api\Data\ImageInterface;
use Xtwo\AttributeOption\Api\Data\ImageSearchResultsInterface;

interface ImageRepositoryInterface
{
    /**
     * Create company
     *
     * @param \Xtwo\AttributeOption\Api\Data\ImageInterface $imageData
     * @return \Xtwo\AttributeOption\Api\Data\ImageInterface
     * @throws \Magento\Framework\Exception\InputException
     * @throws \Magento\Framework\Exception\StateException
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function save(ImageInterface $imageData): ImageInterface;

    /**
     * @param int $id
     * @return \Xtwo\AttributeOption\Api\Data\ImageInterface
     */
    public function getById(int $id): ImageInterface;

    /**
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Xtwo\AttributeOption\Api\Data\ImageSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria): ImageSearchResultsInterface;

    /**
     * Delete image by ID.
     *
     * @param int $id
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById(int $id): bool;
}
