<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */


namespace  Xtwo\AttributeOption\Api\Data;

interface ImageInterface
{
    /**#@+
     * Constants for keys of data array
     */
    const ID = 'entity_id';
    const FILE_NAME = 'file_name';
    const OPTION_ID = 'option_id';
    const ATTRIBUTE_ID = 'attribute_id';
    const STORE_ID = 'store_id';
    /**#@-*/

    /**
     * Identifier getter
     *
     * @return int
     */
    public function getId();

    /**
     * Set entity Id
     *
     * @param int $value
     * @return $this
     */
    public function setId($value);
    /**
     * Get file name
     *
     * @return string|null
     */
    public function getFileName();

    /**
     * Set file name
     *
     * @param string $value
     *
     * @return void
     */
    public function setFileName(string $value);

    /**
     * Get option id
     *
     * @return int|null
     */
    public function getOptionId();

    /**
     * Set option id
     *
     * @param int $value
     *
     * @return void
     */
    public function setOptionId(int $value);

    /**
     * Get attribute id
     *
     * @return int|null
     */
    public function getAttributeId();

    /**
     * Set attribute id
     *
     * @param int $value
     *
     * @return void
     */
    public function setAttributeId(int $value);

    /**
     * Get store id
     *
     * @return int|null
     */
    public function getStoreId();

    /**
     * Set store id
     *
     * @param int $value
     *
     * @return void
     */
    public function setStoreId(String $value);
}
