<?php
namespace Xtwo\AddtsProduct\Model;

use Xtwo\AddtsProduct\Api\TshopInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Catalog\Model\ProductRepository;
use Magento\Quote\Api\Data\CartItemInterfaceFactory;

class Tshop implements TshopInterface
{
	protected $cartRepository;
	protected $request;
	private $tsProductAdded = false;
	protected $productRepository;
	private $quoteItemFactory;
	
	 /**
     * Constructor
     *
     * @param Magento\Quote\Api\CartRepositoryInterface      $cartRepository
     * @param Magento\Framework\App\RequestInterface         $request
   
     */
	
	public function __construct( 
        CartRepositoryInterface $cartRepository,
		RequestInterface $request,
		ProductRepository $productRepository,
		CartItemInterfaceFactory $quoteItemFactory
    ) {
        $this->cartRepository = $cartRepository;
		$this->request = $request;  
		$this->productRepository = $productRepository;
		$this->quoteItemFactory = $quoteItemFactory;
    }
	
    /**
     * @inheritDoc
     */
    public function trustedshop()
    {
		$tsProductId = $this->request->getParam('tsProductId');
		$cartId = $this->request->getParam('cartId');
		
		$quote = $this->cartRepository->getActive($cartId);
		$items = $quote->getItems();
        if ($tsProductId !== "null" && !$this->tsProductAdded) {
			foreach($items as $item){
				
					if ($item['product_type'] == 'buyerprotect') {
					
					$quote->removeItem($item->getId());
				}
				}
				
				$tsProductRepo = $this->productRepository->getById($tsProductId);
				$totalSegments = $totalsData['total_segments'] ?? [];
				$quoteCart = $this->cartRepository->get($cartId);
				$product = $this->productRepository->getById($tsProductId);
				
				$this->addProductToQuote($quote, $product);		//Add product to cart programatically 	
				
				$quoteCart->collectTotals($quote);
				$this->cartRepository->save($quote);
				$TsData['name']['Ts_product'] = $tsProductId;
				return $TsData;
			}
			else
			{
				foreach($items as $item){
					//print_r($item->getId());
				
					if ($item['product_type'] == 'buyerprotect') {
					
					$quote->removeItem($item->getId());
				}
				}
				$quoteCart = $this->cartRepository->get($cartId);
				$quoteCart->collectTotals($quote);
				$this->cartRepository->save($quote);
				$TsData['name']['Ts_product'] = "Trusted Shop Product Has been Removed";
				return $TsData;
			}
    }
	
	private function addProductToQuote($quote, $product)
    {
        $quoteItem = $this->createQuoteItem($product);
        $quote->addItem($quoteItem);
    }
	private function createQuoteItem($product)
    {
        $quoteItem = $this->quoteItemFactory->create();
        $quoteItem->setProduct($product);
        $quoteItem->setQty(1);

        return $quoteItem;
    }
}
