<?php

namespace Meetanshi\GA4\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Checkout\Model\Session;
use Meetanshi\GA4\Helper\Data;
use Magento\Catalog\Model\ProductRepository;
use Magento\Framework\Event\Observer;

/**
 * Class QuoteRemoveProductObserver
 * @package Meetanshi\GA4\Observer
 */
class QuoteRemoveProductObserver implements ObserverInterface
{
    /**
     * @var Data
     */
    protected $helper;
    /**
     * @var ProductRepository
     */
    protected $productRepository;
    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * QuoteRemoveProductObserver constructor.
     * @param Data $helper
     * @param ProductRepository $productRepository
     * @param Session $checkoutSession
     */
    public function __construct(
        Data $helper,
        ProductRepository $productRepository,
        Session $checkoutSession
    )
    {
        $this->helper = $helper;
        $this->productRepository = $productRepository;
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(Observer $observer)
    {
        try {
            if ($this->helper->isEnable()) {
                $quoteItem = $observer->getData('quote_item');
                $productId = $quoteItem->getData('product_id');
                $qty = $quoteItem->getData('qty');

                if ($productId != null && $productId ) {
                    $product = $this->productRepository->getById($productId);
                    $this->checkoutSession->setGA4RemoveCartProduct($this->helper->removeCartData($product, $quoteItem, $qty));
                }
            }
        } catch (\Exception $e) {
            $this->helper->logMessage($e->getMessage());
        }
        return $this;
    }
}
