<?php

namespace Meetanshi\GA4\Observer;

use Magento\Framework\Event\ObserverInterface;
use Meetanshi\GA4\Helper\Data as DataHelper;
use Magento\Checkout\Model\Session;
use Magento\Framework\Locale\ResolverInterface;
use Magento\Framework\Event\Observer;

/**
 * Class AddToCartProductObserver
 * @package Meetanshi\GA4\Observer
 */
class AddToCartProductObserver implements ObserverInterface
{
    /**
     * @var DataHelper
     */
    protected $helper;
    /**
     * @var Session
     */
    protected $session;
    /**
     * @var ResolverInterface
     */
    protected $resolver;

    /**
     * AddToCartProductObserver constructor.
     * @param DataHelper $helper
     * @param Session $session
     * @param ResolverInterface $resolver
     */
    public function __construct(
        DataHelper $helper,
        Session $session,
        ResolverInterface $resolver
    ) {
        $this->helper = $helper;
        $this->session = $session;
        $this->resolver = $resolver;
    }

    /**
     * @param Observer $observer
     * @return $this
     */
    public function execute(Observer $observer)
    {
        if ($this->helper->isEnable()) {
            $product = $observer->getData('product');
            $request = $observer->getData('request');
            $params = $request->getParams();
            $qty = 1;
            if (isset($params['qty'])) {
                $filter = new \Zend_Filter_LocalizedToNormalized(['locale' => $this->resolver->getLocale()]);
                $qty = $filter->filter($params['qty']);
            }
            $this->session->setGA4AddCartProduct($this->helper->addToCartData($qty, $product));
        }
        return $this;
    }
}
