<?php
namespace Mageplaza\Simpleshipping\Model\Carrier;

use Psr\Log\LoggerInterface;

class Restrictshipping
{
    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $checkoutSession;

    /**
     * @param \Magento\Checkout\Model\Session $checkoutSession
     */   
    public function __construct(       
        LoggerInterface $logger
    ) {
       
        $this->logger = $logger;
    }


    /**
     * Disable specific shipping methods.
     *
     * NOTE: If you can not see some of the shipping rates, start debugging from here. At first, check 'is_disabled'
     * param in the shipping rate object.
     *
     * @param \Magento\Shipping\Model\Rate\Result $subject
     * @param array $result
     * @return array
     */
    public function afterGetAllRates($subject, $result)
    {
        $freight_exist = 0;
        foreach ($result as $key => $rate) {
            if ($rate->getCarrier() == 'simpleshipping') {
                $freight_exist = 1;
            }      
        }
        
        foreach($result as $key => $method) {
            if ($freight_exist == 1) {
                if ($method->getCarrier() == 'tablerate') {
                    unset($result[$key]); 
                }
            }
        }

        return $result;
    }

}