<?php

namespace Magecomp\S3Amazon\Controller\Adminhtml\Iframe;

use Magento\Framework\App\Filesystem\DirectoryList;

class Show extends \Magento\Swatches\Controller\Adminhtml\Iframe\Show
{
    
    public function aroundExecute(\Magento\Swatches\Controller\Adminhtml\Iframe\Show $subject, callable $proceed)
    {
        try {
        
            $uploader = $subject->uploaderFactory->create(['fileId' => 'datafile']);
            $uploader->setAllowedExtensions(['jpg', 'jpeg', 'gif', 'png']);
            /** @var \Magento\Framework\Image\Adapter\AdapterInterface $imageAdapter */
            
            $imageAdapter = $subject->adapterFactory->create();
            
            $uploader->addValidateCallback('catalog_product_image', $imageAdapter, 'validateUploadFile');
            $uploader->setAllowRenameFiles(true);
            $uploader->setFilesDispersion(true);
            
            /** @var \Magento\Framework\Filesystem\Directory\Read $mediaDirectory */
            $mediaDirectory = $subject->filesystem->getDirectoryRead(DirectoryList::MEDIA);
            
        
            $config = $subject->config;

            $result = $uploader->save($mediaDirectory->getAbsolutePath($config->getBaseTmpMediaPath()));
           
        
            unset($result['path']);

            $subject->_eventManager->dispatch(
                'swatch_gallery_upload_image_after',
                ['result' => $result, 'action' => $subject]
            );

           
            unset($result['tmp_name']);

            $result['url'] = $subject->config->getTmpMediaUrl($result['file']);
            $result['file'] = $result['file'] . '.tmp';
            $newFile = $subject->swatchHelper->moveImageFromTmp($result['file']);
            $subject->swatchHelper->generateSwatchVariations($newFile);    
            $fileData = ['swatch_path' => $subject->swatchHelper->getSwatchMediaUrl(), 'file_path' => $newFile];  
            $customimage = 'attribute/swatch'.$newFile;
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $objectManager->get('Magecomp\S3Amazon\Model\Core\File\Storage\S3')->saveFile($customimage);

            $subject->getResponse()->setBody(json_encode($fileData));
        } catch (\Exception $e) {
            $result = ['error' => $e->getMessage(), 'errorcode' => $e->getCode()];
            $subject->getResponse()->setBody(json_encode($result));
        }
    }
}
