define(
    [
        'ko',
        'Magento_Checkout/js/view/summary/abstract-total',
        'Magento_Checkout/js/model/quote',
        'Magento_Catalog/js/price-utils',
        'Magento_Checkout/js/model/totals'
    ],
    function (ko,Component, quote, priceUtils, totals) {
        "use strict";
        var show_hide_Extrafee_blockConfig = window.checkoutConfig.show_hide_Extrafee_block;
        var fee_label = window.checkoutConfig.fee_label;
    

        return Component.extend({
            defaults: {
                isFullTaxSummaryDisplayed: window.checkoutConfig.isFullTaxSummaryDisplayed || false,
                template: 'Boolfly_PaymentFee/checkout/summary/fee'
            },
            totals: quote.getTotals(),
            isTaxDisplayedInGrandTotal: window.checkoutConfig.includeTaxInGrandTotal || false,
            getFeeLabel:ko.observable(fee_label),
           
    
            isDisplayed: function() {
                // return this.isFullMode();
                return this.isFullMode() && this.getPureValue() !== 0;
            },

            getValue: function() {
                var price = 0;
                if (this.totals()) {
                    price = totals.getSegment('fee_amount').value;
                }
                return this.getFormattedPrice(price);
               
            },

            getTitle: function() {
               
                return  "HTitle";
            },

            getBaseValue: function() {
                var price = 0;
                if (this.totals()) {
                    price = this.totals().base_payment_charge;
                }
                return priceUtils.formatPrice(price, quote.getBasePriceFormat());
            },
            getPureValue: function() {
                var price = 0;
                if (this.totals()) {
                    price = totals.getSegment('fee_amount').value;
                    
                }
                return price;
            }
        });
    }
);