<?php declare(strict_types=1);

namespace Boolfly\PaymentFee\Observer;

use Boolfly\PaymentFee\Helper\Data;
use Magento\Checkout\Model\Session;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;

/**
 * observer to add fee to order
 * 
 */
class AddFeeToOrderObserver implements ObserverInterface
{
    /**
     * @var Session
     */
    protected $_checkoutSession;

    /** @var Data  */
    protected $_helper;
    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * AddFeeToOrderObserver constructor.
     * @param Session $checkoutSession
     */
    public function __construct(
        Session $checkoutSession,
        Data $helper,
        LoggerInterface $loggerInterface,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Customer\Model\Session $customerSession
    ) {
        $this->_checkoutSession = $checkoutSession;
        $this->_helper = $helper;
        $this->logger = $loggerInterface;
        $this->productFactory = $productFactory;
        $this->customerSession = $customerSession;
    }

    /**
     * Set payment fee to order
     *
     * @param EventObserver $observer
     * @return $this
     */
    public function execute(EventObserver $observer)
    {
        $product = $this->productFactory->create();
        $quote = $observer->getQuote();
        if ($this->_helper->canApply($quote)) {
            $feeAmount = $this->_helper->getFee($quote);       
            $order = $observer->getEvent()->getOrder();
            $order->setData('fee_amount', $feeAmount);
            $order->setData('base_fee_amount', $feeAmount);
            $productid =  $this->customerSession->getTrustedShopsProductId();
            $product->load($productid);         
            // ADDED HERE ORDER ITEM
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $orderItem = $objectManager->create('Magento\Sales\Model\Order\Item');
            $orderItem->setProductId($product->getId());
            $orderItem->setSku($product->getSku());
            $orderItem->setQtyOrdered(1);
            $orderItem->setBasePrice($product->getPrice());
            $orderItem->setPrice($product->getFinalPrice());
            $orderItem->setRowTotal($product->getFinalPrice());
            $orderItem->setOriginalPrice($product->getPrice());
            $orderItem->setProductType($product->getTypeId());
            $order->addItem($orderItem);
            // ADDED HERE ORDER ITEM         
        }

    
    }
}