<?php 

/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

 
declare(strict_types=1);

namespace Boolfly\PaymentFee\Controller\Checkout;

use Exception;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\Json;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Controller\Result\Raw;
use Magento\Framework\Json\Helper\Data;
use Magento\Quote\Api\CartRepositoryInterface;
use Psr\Log\LoggerInterface;

/**
 * to add remove Buyer Protection Fees
 * to total
 */
class Totals extends Action
{
    /**
     * @var Session
     */
    protected $_checkoutSession;

    /**
     * @var JsonFactory
     */
    protected $_resultJson;

    /**
     * @var Data
     */
    protected $_helper;
    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * @var CartRepositoryInterface
     */
    protected $quoteRepository;

    public function __construct(
        Context $context,
        Session $checkoutSession,
        Data $Jsonhelper,
        JsonFactory $resultJson,
        CartRepositoryInterface $quoteRepository,
        LoggerInterface $loggerInterface,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Checkout\Model\Cart $cart,
        \Magento\Framework\Data\Form\FormKey $formKey,
        \Xtwo\Buyerprotect\Helper\Data $buyer_prot_helper,
        \Magento\Framework\App\RequestInterface $req,      
        \Magento\Framework\Event\ManagerInterface $eventManager,
        \Magento\Customer\Model\Session $customerSession
             
    ) {
        parent::__construct($context);
        $this->_checkoutSession = $checkoutSession;
        $this->Jsonhelper =$Jsonhelper;
        $this->_resultJson = $resultJson;
        $this->quoteRepository = $quoteRepository;
        $this->logger = $loggerInterface;
        $this->productFactory = $productFactory;
        $this->formKey = $formKey;
        $this->cart = $cart;
        $this->_helper = $buyer_prot_helper;
        $this->req =  $req;       
        $this->eventManager = $eventManager;
        $this->customerSession = $customerSession;
    }

  
    /**
     * Trigger to re-calculate the collect Totals
     *
     * @return Json
     */
    public function execute()
    {
        $response = [
            'errors' => false,
            'message' => 'Re-calculate successful.'
        ];
        try {     
           $payment = $this->Jsonhelper->jsonDecode($this->getRequest()->getContent());
           $this->quoteRepository->get($this->_checkoutSession->getQuoteId());            
            $this->product = $this->productFactory->create();
            $id = $payment['trusted_shops_product'];
            $id_text = $payment['trusted_shops_product_text'];
            $id_text = str_replace('\n'," ",$id_text);
            $id_text = str_replace('\s'," ",$id_text);
            $checked = $payment['trusted_shops'];
            $params = array(
                'form_key' => $this->formKey->getFormKey(),
                'product_id' => $id, //product Id
                'qty'   => 1 //quantity of product                      
                );

            $response = [
                'errors' => false,
                'message' => 'Re-calculate successful.',
                'id' => $id,
                'checked' => $checked,
                'desc' => $id_text
            ];

            if($checked == 1){
              $product = $this->product->load($id);
              $product_price = $product->getPrice();

            $this->_checkoutSession->getQuote()->setFeeAmount($product_price);
            $this->_checkoutSession->getQuote()->setTrustedShopsProductId($id);
            $this->_checkoutSession->getQuote()->setTrustedShopsProductText($id_text);
            $this->_checkoutSession->getQuote()->setTrustedShops($checked);
            $this->customerSession->setTrustedShops($checked);
            $this->customerSession->setFeeAmount($product_price);
            $this->customerSession->setTrustedShopsProductId($id);
            $this->customerSession->setTrustedShopsProductIdText($id_text);
            $quote = $this->_checkoutSession->getQuote();
            // Trigger to re-calculate totals            
            $this->_checkoutSession->getQuote()->getPayment()->setMethod($payment['payment']);
            $quote->collectTotals()->save();
            $this->quoteRepository->save($quote);
            } else if($checked == 0){
               $quote_id = $this->_checkoutSession->getId();
               $this->_checkoutSession->getQuote()->setFeeAmount(0);
               $quote = $this->_checkoutSession->getQuote();
            // Trigger to re-calculate totals            
              $this->_checkoutSession->getQuote()->getPayment()->setMethod($payment['payment']);
              $quote->collectTotals()->save();
              $this->quoteRepository->save($quote);
                $response = [
                    'errors' => true,
                    'message' => 'not checked'
                ];

            } else if($checked == ''){

                $response = [
                    'errors' => true,
                    'message' => 'check box empty',
                    'desc' => $id_text
                ];

            }
        } catch (Exception $e) {
            $response = [
                'errors' => true,
                'message' => $e->getMessage(),
                'desc' => $id_text
            ];
        }

        /** @var Raw $resultRaw */
        $resultJson = $this->_resultJson->create();
        return $resultJson->setData($response);
    }    
}