<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2021 Amasty (https://www.amasty.com)
 * @package Amasty_AdminActionsLog
 */


declare(strict_types=1);

namespace Amasty\AdminActionsLog\Logging\ActionType\Validation;

use Amasty\AdminActionsLog\Api\Logging\MetadataInterface;
use Amasty\AdminActionsLog\Model\ConfigProvider;

class LoggingVisitHistoryValidator implements ActionValidatorInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var bool|null
     */
    private $validationResult = null;

    public function __construct(ConfigProvider $configProvider)
    {
        $this->configProvider = $configProvider;
    }

    public function isValid(MetadataInterface $metadata): bool
    {
        if ($this->validationResult === null) {
            $this->validationResult = $this->configProvider->isEnabledLogVisitHistory();
        }

        return $this->validationResult;
    }
}
