<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2021 Amasty (https://www.amasty.com)
 * @package Amasty_AdminActionsLog
 */


declare(strict_types=1);

namespace Amasty\AdminActionsLog\Logging\ActionType\Validation;

use Amasty\AdminActionsLog\Api\Logging\MetadataInterface;

interface ActionValidatorInterface
{
    /**
     * Validate Action Metadata.
     *
     * @param MetadataInterface $metadata
     * @return bool
     */
    public function isValid(MetadataInterface $metadata): bool;
}
