<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2021 Amasty (https://www.amasty.com)
 * @package Amasty_AdminActionsLog
 */


namespace Amasty\AdminActionsLog\Api\Restoring;

use Amasty\AdminActionsLog\Api\Data\LogEntryInterface;

interface EntityRestoreHandlerInterface
{
    /**
     * Perform restoring action by action log details
     *
     * @param \Amasty\AdminActionsLog\Api\Data\LogEntryInterface $logEntry
     * @param \Amasty\AdminActionsLog\Api\Data\LogDetailInterface[] $logDetails
     * @return void
     */
    public function restore(LogEntryInterface $logEntry, array $logDetails): void;
}
